<?php 
return [
  'settings_title' => 'Configurações MultiPOS',
  'help_text' => 'Gerencie e configure suas máquinas POS',
  'info' => [
    'registration_title' => 'Cadastro de Máquina',
    'registration_text' => 'Quando os usuários acessam a página do PDV sem um dispositivo registrado, eles serão solicitados a registrá-lo. Novos registros aparecem como “Pendentes” e necessitam de aprovação.',
    'status_title' => 'Guia de status',
    'status_active' => 'Ativo',
    'status_pending' => 'Pendente',
    'status_declined' => 'Recusado',
    'status_active_text' => 'Aprovado e pode processar pedidos',
    'status_pending_text' => 'Aguardando aprovação',
    'status_declined_text' => 'Acesso negado, entre em contato com o administrador',
  ],
  'table' => [
    'registered_for_branch' => 'Máquinas Cadastradas para Filial: :branch',
    'alias' => 'Alias',
    'machine_id' => 'ID da máquina',
    'status' => 'Status',
    'last_seen' => 'Visto pela última vez',
    'registered' => 'Registrado',
    'actions' => 'Ações',
    'no_alias' => 'Sem apelido',
    'never' => 'Nunca',
    'no_machines' => 'Nenhuma máquina cadastrada',
    'no_machines_hint' => 'Os dispositivos aparecerão aqui quando os usuários os registrarem na página do PDV.',
  ],
  'actions' => [
    'approve' => 'Aprovar',
    'decline' => 'Declínio',
    'save' => 'Salvar',
    'cancel' => 'Cancelar',
    'edit' => 'Editar',
    'delete' => 'Excluir',
  ],
  'usage' => [
    'title' => 'Uso da máquina POS (:mês Ano)',
    'no_data' => 'Nenhuma máquina POS encontrada para este restaurante em :monthYear',
    'headers' => [
      'no' => 'Não.',
      'alias' => 'Alias ​​da máquina',
      'branch' => 'Filial',
      'machine_id' => 'ID da máquina',
      'status' => 'Status',
      'orders_current_month' => 'Pedidos (mês atual)',
      'revenue_current_month' => 'Receita (mês atual)',
      'last_seen' => 'Visto pela última vez',
    ],
  ],
  'machines' => [
    'title' => 'Gestão de Máquinas POS',
    'pending_approvals' => 'Aprovações pendentes (:count)',
    'filters' => [
      'all' => 'Todas as máquinas',
      'active' => 'Ativo',
      'pending' => 'Pendente',
      'declined' => 'Recusado',
    ],
    'table' => [
      'alias' => 'Alias',
      'machine_id' => 'ID da máquina',
      'status' => 'Status',
      'last_seen' => 'Visto pela última vez',
      'created' => 'Criado',
      'actions' => 'Ações',
      'no_alias' => 'Sem apelido',
    ],
    'buttons' => [
      'view' => 'Visualizar',
      'approve' => 'Aprovar',
      'edit' => 'Editar',
      'decline' => 'Declínio',
    ],
    'empty' => [
      'title' => 'Nenhuma máquina cadastrada',
      'hint' => 'Os dispositivos aparecerão aqui assim que forem registrados na página do PDV.',
    ],
    'modal' => [
      'title' => 'Detalhes da máquina',
      'statistics' => 'Estatísticas',
      'total_orders' => 'Total de pedidos',
      'today_orders' => 'Encomendas de hoje',
    ],
    'confirm' => [
      'approve' => 'Aprova esta máquina POS?',
      'decline' => 'Desativar esta máquina POS? Será necessário registrar-se novamente.',
    ],
  ],
  'reports' => [
    'title' => 'Relatório de máquina POS',
    'filter' => 'Filtro',
    'export_csv' => 'Exportar CSV',
    'customDateRange' => 'Intervalo de datas personalizado',
    'pos_only' => 'Somente PDV sábio',
    'pos_machine' => 'Máquina PDV',
    'cards' => [
      'total_machines' => 'Máquinas totais',
      'total_orders' => 'Total de pedidos',
      'net_sales' => 'Vendas Líquidas',
      'avg_order_value' => 'Valor médio do pedido',
    ],
    'table' => [
      'title' => 'Desempenho da máquina',
      'pos_machine' => 'Máquina PDV',
      'orders' => 'Pedidos',
      'net_sales' => 'Vendas Líquidas',
      'avg_order' => 'Pedido médio',
      'cash_sales' => 'Vendas à vista',
      'card_upi_sales' => 'Vendas de cartão/UPI',
      'refunds' => 'Reembolsos',
    ],
    'empty' => [
      'title' => 'Não há dados disponíveis',
      'hint' => 'Tente selecionar um período diferente.',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => 'Registro recusado',
      'message' => 'Sua solicitação de registro no PDV foi recusada. Entre em contato com seu administrador para obter assistência.',
      'check_status' => 'Verifique o status novamente',
    ],
    'pending' => [
      'title' => 'Registro pendente',
      'message' => 'Aguardando aprovação do administrador. O acesso ao PDV está atualmente bloqueado até que seu dispositivo seja aprovado.',
      'refresh_status' => 'Atualizar status',
      'approve_this_machine' => 'Aprovar esta máquina',
      'go_to_settings' => 'Vá para Configurações',
    ],
    'active' => [
      'label' => 'PDV:',
    ],
    'limit_reached' => [
      'title' => 'Limite de máquina POS atingido',
      'message' => 'Limite de máquinas POS atingido para esta agência (limite: :limit). Entre em contato com seu administrador.',
      'what_can_you_do' => 'O que você pode fazer?',
      'hint' => 'Contate seu administrador para aumentar o limite de máquinas POS ou remover máquinas inativas.',
    ],
    'form' => [
      'title' => 'Registre este dispositivo como um PDV',
      'description' => 'Para utilizar o sistema POS, este dispositivo deve estar registrado. Todos os pedidos serão vinculados a este dispositivo.',
      'select_branch' => 'Selecione filial',
      'select_branch_placeholder' => 'Escolha uma filial...',
      'select_branch_error' => 'Selecione uma filial',
      'device_name' => 'Nome do dispositivo (opcional)',
      'device_name_placeholder' => 'por exemplo, Balcão 1, Bar POS, Quiosque 1',
      'device_name_hint' => 'Dê a este dispositivo um nome amigável para facilitar a identificação.',
      'what_happens_next' => 'O que acontece a seguir?',
      'what_happens_next_text' => 'Após o registro, você precisará da aprovação do administrador antes que o dispositivo se torne ativo.',
      'register_button' => 'Registrar dispositivo',
      'cancel_button' => 'Cancelar e voltar',
      'go_to_dashboard' => 'Vá para o painel',
    ],
    'device' => 'Dispositivo',
    'already_registered' => 'Este dispositivo já está registrado como :alias.',
    'limit_reached_error' => 'Limite de máquinas POS atingido para esta agência (limite: :limit). Entre em contato com seu administrador.',
    'registered_success' => 'Dispositivo POS registrado e ativado com sucesso como :alias (:public_id)',
    'registered_pending' => 'Sua solicitação de registro foi enviada. Aguardando aprovação do administrador. Você poderá usar o PDV depois de aprovado.',
  ],
  'settings' => [
    'machine_not_pending' => 'A máquina não está com aprovação pendente',
    'user_not_found' => 'Usuário não encontrado',
    'machine_approved' => 'Máquina aprovada com sucesso',
    'machine_already_declined' => 'A máquina já foi recusada',
    'machine_declined' => 'Máquina recusada com sucesso',
    'alias_required' => 'O alias é obrigatório',
    'machine_updated' => 'Máquina atualizada com sucesso',
    'machine_deleted' => 'Máquina excluída com sucesso',
    'delete_machine_title' => 'Excluir máquina POS?',
    'delete_machine_message' => 'Tem certeza de que deseja excluir esta máquina PDV? Esta ação não pode ser desfeita.',
  ],
  'js' => [
    'network_error' => 'A resposta da rede não foi boa',
    'error_checking_limit' => 'Erro ao verificar limite de ramificação',
    'limit_reached_message' => 'Limite de máquinas POS atingido para esta agência (limite: :limit). Entre em contato com seu administrador.',
    'error_loading_report' => 'Erro ao carregar dados do relatório. Por favor, tente novamente.',
    'edit_coming_soon' => 'Funcionalidade de edição em breve',
    'unnamed' => 'Sem nome',
  ],
  'dashboard' => [
    'title' => 'Gerenciamento MultiPOS',
    'manage_terminals' => 'Gerenciar terminais',
    'settings' => 'Configurações',
    'pos_machines_branch' => 'Máquinas POS (Filial)',
    'unlimited' => 'Ilimitado',
    'active_limit' => '(Ativo/Limite)',
    'pending_label' => 'Pendente:',
    'total_terminals' => 'Total de Terminais',
    'active_orders' => 'Pedidos Ativos',
    'todays_revenue' => 'Receita de hoje',
    'total_tables' => 'Total de tabelas',
    'quick_actions' => 'Ações rápidas',
    'pos_terminal' => 'Terminal PDV',
    'take_orders' => 'Receber pedidos',
    'configure_pos_terminals' => 'Configurar terminais POS',
    'configure_multipos' => 'Configurar MultiPOS',
    'branch_label' => 'Filial:',
    'used_label' => 'Usado:',
  ],
  'claim' => [
    'title' => 'Registre este dispositivo como um PDV',
    'description' => 'Isso registrará seu dispositivo atual para rastrear pedidos e sessões de caixa registradora.',
    'branch_label' => 'Filial',
    'branch_required' => 'Filial',
    'select_branch' => 'Selecione uma filial',
    'device_alias_label' => 'Alias ​​do dispositivo (opcional)',
    'device_alias_placeholder' => 'por exemplo, Balcão 1, Bar POS, Quiosque 1',
    'device_alias_hint' => 'Dê a este dispositivo um nome amigável para facilitar a identificação.',
    'what_happens_next_title' => 'O que acontece a seguir?',
    'what_happens_next_message' => 'Após o registro, este dispositivo será rastreado para todos os pedidos e transações. Talvez seu administrador precise aprovar este dispositivo antes que ele fique ativo.',
    'cancel' => 'Cancelar',
    'register_device' => 'Registrar dispositivo',
    'select_branch_alert' => 'Selecione uma filial',
  ],
  'terminals' => [
    'title' => 'Gestão de Terminais POS',
    'pos_terminals' => 'Terminais POS',
    'add_terminal' => 'Adicionar terminal',
    'back_to_dashboard' => 'Voltar ao painel',
    'edit_terminal' => 'Editar terminal',
    'delete_terminal' => 'Excluir',
    'no_terminals' => 'Sem terminais',
    'get_started' => 'Comece criando um novo terminal POS.',
    'terminal_name' => 'Nome do Terminal',
    'type' => 'Tipo',
    'active' => 'Ativo',
    'cancel' => 'Cancelar',
    'save' => 'Salvar',
    'delete_confirm' => 'Tem certeza de que deseja excluir este terminal?',
    'table' => [
      'name' => 'Nome',
      'type' => 'Tipo',
      'printer' => 'Impressora',
      'status' => 'Status',
      'default' => 'Padrão',
      'actions' => 'Ações',
    ],
    'status' => [
      'active' => 'Ativo',
      'inactive' => 'Inativo',
    ],
    'type_options' => [
      'food' => 'Comida',
      'beverage' => 'Bebida',
      'general' => 'Em geral',
    ],
    'no_printer' => 'Sem impressora',
    'default' => 'Padrão',
  ],
  'package' => [
    'multiposLimit' => 'Limite de máquinas MultiPOS',
    'multiposLimitInfo' => 'Este é um limite por ramificação. Insira -1 para máquinas POS ilimitadas por filial. Deixe em branco ou defina um número positivo para definir um limite por filial.',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => 'Solicitação de registro de nova máquina POS',
      'push_title' => 'Solicitação de registro de PDV',
      'push_message' => ':alias solicitou acesso POS para filial :branch',
      'text1' => 'Uma nova solicitação de registro de máquina POS foi enviada.',
      'text2' => 'Revise e aprove ou recuse a solicitação:',
      'text3' => 'Você pode gerenciar todas as solicitações da máquina POS na página de configurações do MultiPOS.',
      'action' => 'Solicitação de revisão',
    ],
  ],
];