<?php 
return [
  'settings_title' => '多POS设置',
  'help_text' => '管理和配置您的 POS 机',
  'info' => [
    'registration_title' => '机器注册',
    'registration_text' => '当用户在没有注册设备的情况下访问 POS 页面时，系统会提示他们注册。新注册显示为“待处理”并需要批准。',
    'status_title' => '状态指南',
    'status_active' => '积极的',
    'status_pending' => '待办的',
    'status_declined' => '拒绝',
    'status_active_text' => '已批准并可以处理订单',
    'status_pending_text' => '等待批准',
    'status_declined_text' => '访问被拒绝，请联系管理员',
  ],
  'table' => [
    'registered_for_branch' => '分行注册机器： :branch',
    'alias' => '别名',
    'machine_id' => '机器ID',
    'status' => '地位',
    'last_seen' => '最后一次出现',
    'registered' => '挂号的',
    'actions' => '行动',
    'no_alias' => '无别名',
    'never' => '绝不',
    'no_machines' => '没有注册机器',
    'no_machines_hint' => '当用户从 POS 页面注册设备时，设备将显示在此处。',
  ],
  'actions' => [
    'approve' => '批准',
    'decline' => '衰退',
    'save' => '节省',
    'cancel' => '取消',
    'edit' => '编辑',
    'delete' => '删除',
  ],
  'usage' => [
    'title' => 'POS机使用情况（：月、年）',
    'no_data' => '在 :monthYear 中未找到该餐厅的 POS 机',
    'headers' => [
      'no' => '不。',
      'alias' => '机器别名',
      'branch' => '分支',
      'machine_id' => '机器ID',
      'status' => '地位',
      'orders_current_month' => '订单（当月）',
      'revenue_current_month' => '收入（当月）',
      'last_seen' => '最后一次出现',
    ],
  ],
  'machines' => [
    'title' => 'POS机管理',
    'pending_approvals' => '待批准（：计数）',
    'filters' => [
      'all' => '所有机器',
      'active' => '积极的',
      'pending' => '待办的',
      'declined' => '拒绝',
    ],
    'table' => [
      'alias' => '别名',
      'machine_id' => '机器ID',
      'status' => '地位',
      'last_seen' => '最后一次出现',
      'created' => '已创建',
      'actions' => '行动',
      'no_alias' => '无别名',
    ],
    'buttons' => [
      'view' => '看法',
      'approve' => '批准',
      'edit' => '编辑',
      'decline' => '衰退',
    ],
    'empty' => [
      'title' => '没有注册机器',
      'hint' => '从 POS 页面注册后，设备将显示在此处。',
    ],
    'modal' => [
      'title' => '机器详情',
      'statistics' => '统计数据',
      'total_orders' => '订单总数',
      'today_orders' => '今日订单',
    ],
    'confirm' => [
      'approve' => '批准这台 POS 机吗？',
      'decline' => '禁用此 POS 机？需要重新注册。',
    ],
  ],
  'reports' => [
    'title' => 'POS机报告',
    'filter' => '筛选',
    'export_csv' => '导出 CSV',
    'customDateRange' => '自定义日期范围',
    'pos_only' => '仅限 POS 明智',
    'pos_machine' => 'POS机',
    'cards' => [
      'total_machines' => '机器总数',
      'total_orders' => '订单总数',
      'net_sales' => '净销售额',
      'avg_order_value' => '平均订单价值',
    ],
    'table' => [
      'title' => '机器性能',
      'pos_machine' => 'POS机',
      'orders' => '订单',
      'net_sales' => '净销售额',
      'avg_order' => '平均订单',
      'cash_sales' => '现金销售',
      'card_upi_sales' => '卡/UPI 销售',
      'refunds' => '退款',
    ],
    'empty' => [
      'title' => '无可用数据',
      'hint' => '尝试选择不同的日期范围。',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => '注册被拒绝',
      'message' => '您的 POS 注册请求已被拒绝。请联系您的管理员寻求帮助。',
      'check_status' => '再次检查状态',
    ],
    'pending' => [
      'title' => '注册待定',
      'message' => '等待管理员批准。在您的设备获得批准之前，POS 访问目前已被阻止。',
      'refresh_status' => '刷新状态',
      'approve_this_machine' => '批准这台机器',
      'go_to_settings' => '前往“设置”',
    ],
    'active' => [
      'label' => '销售点：',
    ],
    'limit_reached' => [
      'title' => 'POS机已达限额',
      'message' => '该分行 POS 机已达到限制（限制： :limit）。请联系您的管理员。',
      'what_can_you_do' => '你能做什么？',
      'hint' => '请联系您的管理员以增加 POS 机器限制或删除不活动的机器。',
    ],
    'form' => [
      'title' => '将此设备注册为 POS',
      'description' => '要使用 POS 系统，必须注册该设备。所有订单都将链接到该设备。',
      'select_branch' => '选择分行',
      'select_branch_placeholder' => '选择分行...',
      'select_branch_error' => '请选择分行',
      'device_name' => '设备名称（可选）',
      'device_name_placeholder' => '例如，柜台 1、酒吧 POS、自助服务终端 1',
      'device_name_hint' => '为该设备指定一个友好的名称，以便于识别。',
      'what_happens_next' => '接下来会发生什么？',
      'what_happens_next_text' => '注册后，您需要获得管理员批准才能激活设备。',
      'register_button' => '注册设备',
      'cancel_button' => '取消并返回',
      'go_to_dashboard' => '转到仪表板',
    ],
    'device' => '设备',
    'already_registered' => '该设备已注册为 :alias。',
    'limit_reached_error' => '该分行 POS 机已达到限制（限制： :limit）。请联系您的管理员。',
    'registered_success' => 'POS 设备已成功注册并激活为 :alias (:public_id)',
    'registered_pending' => '您的注册请求已提交。等待管理员批准。一旦获得批准，您就可以使用 POS。',
  ],
  'settings' => [
    'machine_not_pending' => '机器未等待批准',
    'user_not_found' => '未找到用户',
    'machine_approved' => '机器批准成功',
    'machine_already_declined' => '机器已被拒绝',
    'machine_declined' => '机器拒绝成功',
    'alias_required' => '别名为必填项',
    'machine_updated' => '机器更新成功',
    'machine_deleted' => '机器删除成功',
    'delete_machine_title' => '删除POS机？',
    'delete_machine_message' => '您确定要删除此 POS 机吗？此操作无法撤消。',
  ],
  'js' => [
    'network_error' => '网络响应不好',
    'error_checking_limit' => '检查分支限制时出错',
    'limit_reached_message' => '该分行 POS 机已达到限制（限制： :limit）。请联系您的管理员。',
    'error_loading_report' => '加载报告数据时出错。请再试一次。',
    'edit_coming_soon' => '编辑功能即将推出',
    'unnamed' => '未命名',
  ],
  'dashboard' => [
    'title' => '多POS管理',
    'manage_terminals' => '管理终端',
    'settings' => '设置',
    'pos_machines_branch' => 'POS机（分行）',
    'unlimited' => '无限',
    'active_limit' => '（有效/限制）',
    'pending_label' => '待办的：',
    'total_terminals' => '终端总数',
    'active_orders' => '活跃订单',
    'todays_revenue' => '今日收入',
    'total_tables' => '总表数',
    'quick_actions' => '快速行动',
    'pos_terminal' => 'POS终端',
    'take_orders' => '秉承',
    'configure_pos_terminals' => '配置POS终端',
    'configure_multipos' => '配置多POS',
    'branch_label' => '分支：',
    'used_label' => '用过的：',
  ],
  'claim' => [
    'title' => '将此设备注册为 POS',
    'description' => '这将注册您当前的设备以跟踪订单和收银会话。',
    'branch_label' => '分支',
    'branch_required' => '分支',
    'select_branch' => '选择分行',
    'device_alias_label' => '设备别名（可选）',
    'device_alias_placeholder' => '例如，柜台 1、酒吧 POS、自助服务终端 1',
    'device_alias_hint' => '为该设备指定一个友好的名称，以便于识别。',
    'what_happens_next_title' => '接下来会发生什么？',
    'what_happens_next_message' => '注册后，将跟踪该设备的所有订单和交易。您的管理员可能需要批准此设备才能激活。',
    'cancel' => '取消',
    'register_device' => '注册设备',
    'select_branch_alert' => '请选择分行',
  ],
  'terminals' => [
    'title' => 'POS终端管理',
    'pos_terminals' => 'POS终端',
    'add_terminal' => '添加终端',
    'back_to_dashboard' => '返回仪表板',
    'edit_terminal' => '编辑终端',
    'delete_terminal' => '删除',
    'no_terminals' => '无终端',
    'get_started' => '首先创建一个新的 POS 终端。',
    'terminal_name' => '终端名称',
    'type' => '类型',
    'active' => '积极的',
    'cancel' => '取消',
    'save' => '节省',
    'delete_confirm' => '您确定要删除该终端吗？',
    'table' => [
      'name' => '姓名',
      'type' => '类型',
      'printer' => '打印机',
      'status' => '地位',
      'default' => '默认',
      'actions' => '行动',
    ],
    'status' => [
      'active' => '积极的',
      'inactive' => '不活跃',
    ],
    'type_options' => [
      'food' => '食物',
      'beverage' => '饮料',
      'general' => '一般的',
    ],
    'no_printer' => '无打印机',
    'default' => '默认',
  ],
  'package' => [
    'multiposLimit' => '多POS机限制',
    'multiposLimitInfo' => '这是分支限制。输入 -1 表示每个分支机构的 POS 机数量不受限制。留空或设置正数以设置每个分支的限制。',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => '新 POS 机注册请求',
      'push_title' => 'POS 注册请求',
      'push_message' => ':alias 已请求 :branch 分行的 POS 访问权限',
      'text1' => '已提交新的 POS 机注册请求。',
      'text2' => '请审核并批准或拒绝请求：',
      'text3' => '您可以从 MultiPOS 设置页面管理所有 POS 机请求。',
      'action' => '审核请求',
    ],
  ],
];