<?php 
return [
  'settings_title' => '多POS設置',
  'help_text' => '管理和配置您的 POS 機',
  'info' => [
    'registration_title' => '機器註冊',
    'registration_text' => '當用戶在沒有註冊設備的情況下訪問 POS 頁面時，系統會提示他們註冊。新註冊顯示為“待處理”並需要批准。',
    'status_title' => '狀態指南',
    'status_active' => '積極的',
    'status_pending' => '待辦的',
    'status_declined' => '拒絕',
    'status_active_text' => '已批准並可以處理訂單',
    'status_pending_text' => '等待批准',
    'status_declined_text' => '訪問被拒絕，請聯繫管理員',
  ],
  'table' => [
    'registered_for_branch' => '分行註冊機器： :branch',
    'alias' => '別名',
    'machine_id' => '機器ID',
    'status' => '地位',
    'last_seen' => '最後一次出現',
    'registered' => '掛號的',
    'actions' => '行動',
    'no_alias' => '無別名',
    'never' => '絕不',
    'no_machines' => '沒有註冊機器',
    'no_machines_hint' => '當用戶從 POS 頁面註冊設備時，設備將顯示在此處。',
  ],
  'actions' => [
    'approve' => '批准',
    'decline' => '衰退',
    'save' => '節省',
    'cancel' => '取消',
    'edit' => '編輯',
    'delete' => '刪除',
  ],
  'usage' => [
    'title' => 'POS機使用情況（：月、年）',
    'no_data' => '在 :monthYear 中未找到該餐廳的 POS 機',
    'headers' => [
      'no' => '不。',
      'alias' => '機器別名',
      'branch' => '分支',
      'machine_id' => '機器ID',
      'status' => '地位',
      'orders_current_month' => '訂單（當月）',
      'revenue_current_month' => '收入（當月）',
      'last_seen' => '最後一次出現',
    ],
  ],
  'machines' => [
    'title' => 'POS機管理',
    'pending_approvals' => '待批准（：計數）',
    'filters' => [
      'all' => '所有機器',
      'active' => '積極的',
      'pending' => '待辦的',
      'declined' => '拒絕',
    ],
    'table' => [
      'alias' => '別名',
      'machine_id' => '機器ID',
      'status' => '地位',
      'last_seen' => '最後一次出現',
      'created' => '已創建',
      'actions' => '行動',
      'no_alias' => '無別名',
    ],
    'buttons' => [
      'view' => '看法',
      'approve' => '批准',
      'edit' => '編輯',
      'decline' => '衰退',
    ],
    'empty' => [
      'title' => '沒有註冊機器',
      'hint' => '從 POS 頁面註冊後，設備將顯示在此處。',
    ],
    'modal' => [
      'title' => '機器詳情',
      'statistics' => '統計數據',
      'total_orders' => '訂單總數',
      'today_orders' => '今日訂單',
    ],
    'confirm' => [
      'approve' => '批准這台 POS 機嗎？',
      'decline' => '禁用此 POS 機？需要重新註冊。',
    ],
  ],
  'reports' => [
    'title' => 'POS機報告',
    'filter' => '篩選',
    'export_csv' => '導出 CSV',
    'customDateRange' => '自定義日期範圍',
    'pos_only' => '僅限 POS 明智',
    'pos_machine' => 'POS機',
    'cards' => [
      'total_machines' => '機器總數',
      'total_orders' => '訂單總數',
      'net_sales' => '淨銷售額',
      'avg_order_value' => '平均訂單價值',
    ],
    'table' => [
      'title' => '機器性能',
      'pos_machine' => 'POS機',
      'orders' => '訂單',
      'net_sales' => '淨銷售額',
      'avg_order' => '平均訂單',
      'cash_sales' => '現金銷售',
      'card_upi_sales' => '卡/UPI 銷售',
      'refunds' => '退款',
    ],
    'empty' => [
      'title' => '無可用數據',
      'hint' => '嘗試選擇不同的日期範圍。',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => '註冊被拒絕',
      'message' => '您的 POS 註冊請求已被拒絕。請聯繫您的管理員尋求幫助。',
      'check_status' => '再次檢查狀態',
    ],
    'pending' => [
      'title' => '註冊待定',
      'message' => '等待管理員批准。在您的設備獲得批准之前，POS 訪問目前已被阻止。',
      'refresh_status' => '刷新狀態',
      'approve_this_machine' => '批准這台機器',
      'go_to_settings' => '前往“設置”',
    ],
    'active' => [
      'label' => '銷售點：',
    ],
    'limit_reached' => [
      'title' => 'POS機已達限額',
      'message' => '該分行 POS 機已達到限制（限制： :limit）。請聯繫您的管理員。',
      'what_can_you_do' => '你能做什麼？',
      'hint' => '請聯繫您的管理員以增加 POS 機器限製或刪除不活動的機器。',
    ],
    'form' => [
      'title' => '將此設備註冊為 POS',
      'description' => '要使用 POS 系統，必須註冊該設備。所有訂單都將鏈接到該設備。',
      'select_branch' => '選擇分行',
      'select_branch_placeholder' => '選擇分行...',
      'select_branch_error' => '請選擇分行',
      'device_name' => '設備名稱（可選）',
      'device_name_placeholder' => '例如，櫃檯 1、酒吧 POS、自助服務終端 1',
      'device_name_hint' => '為該設備指定一個友好的名稱，以便於識別。',
      'what_happens_next' => '接下來會發生什麼？',
      'what_happens_next_text' => '註冊後，您需要獲得管理員批准才能激活設備。',
      'register_button' => '註冊設備',
      'cancel_button' => '取消並返回',
      'go_to_dashboard' => '轉到儀表板',
    ],
    'device' => '裝置',
    'already_registered' => '該設備已註冊為 :alias。',
    'limit_reached_error' => '該分行 POS 機已達到限制（限制： :limit）。請聯繫您的管理員。',
    'registered_success' => 'POS 設備已成功註冊並激活為 :alias (:public_id)',
    'registered_pending' => '您的註冊請求已提交。等待管理員批准。一旦獲得批准，您就可以使用 POS。',
  ],
  'settings' => [
    'machine_not_pending' => '機器未等待批准',
    'user_not_found' => '未找到用戶',
    'machine_approved' => '機器批准成功',
    'machine_already_declined' => '機器已被拒絕',
    'machine_declined' => '機器拒絕成功',
    'alias_required' => '別名為必填項',
    'machine_updated' => '機器更新成功',
    'machine_deleted' => '機器刪除成功',
    'delete_machine_title' => '刪除POS機？',
    'delete_machine_message' => '您確定要刪除此 POS 機嗎？此操作無法撤消。',
  ],
  'js' => [
    'network_error' => '網絡響應不好',
    'error_checking_limit' => '檢查分支限制時出錯',
    'limit_reached_message' => '該分行 POS 機已達到限制（限制： :limit）。請聯繫您的管理員。',
    'error_loading_report' => '加載報告數據時出錯。請再試一次。',
    'edit_coming_soon' => '編輯功能即將推出',
    'unnamed' => '未命名',
  ],
  'dashboard' => [
    'title' => '多POS管理',
    'manage_terminals' => '管理終端',
    'settings' => '設定',
    'pos_machines_branch' => 'POS機（分行）',
    'unlimited' => '無限',
    'active_limit' => '（有效/限制）',
    'pending_label' => '待辦的：',
    'total_terminals' => '終端總數',
    'active_orders' => '活躍訂單',
    'todays_revenue' => '今日收入',
    'total_tables' => '總表數',
    'quick_actions' => '快速行動',
    'pos_terminal' => 'POS終端',
    'take_orders' => '秉承',
    'configure_pos_terminals' => '配置POS終端',
    'configure_multipos' => '配置多POS',
    'branch_label' => '分支：',
    'used_label' => '用過的：',
  ],
  'claim' => [
    'title' => '將此設備註冊為 POS',
    'description' => '這將註冊您當前的設備以跟踪訂單和收銀會話。',
    'branch_label' => '分支',
    'branch_required' => '分支',
    'select_branch' => '選擇分行',
    'device_alias_label' => '設備別名（可選）',
    'device_alias_placeholder' => '例如，櫃檯 1、酒吧 POS、自助服務終端 1',
    'device_alias_hint' => '為該設備指定一個友好的名稱，以便於識別。',
    'what_happens_next_title' => '接下來會發生什麼？',
    'what_happens_next_message' => '註冊後，將跟踪該設備的所有訂單和交易。您的管理員可能需要批准此設備才能激活。',
    'cancel' => '取消',
    'register_device' => '註冊設備',
    'select_branch_alert' => '請選擇分行',
  ],
  'terminals' => [
    'title' => 'POS終端管理',
    'pos_terminals' => 'POS終端',
    'add_terminal' => '添加終端',
    'back_to_dashboard' => '返回儀表板',
    'edit_terminal' => '編輯終端',
    'delete_terminal' => '刪除',
    'no_terminals' => '無終端',
    'get_started' => '首先創建一個新的 POS 終端。',
    'terminal_name' => '終端名稱',
    'type' => '類型',
    'active' => '積極的',
    'cancel' => '取消',
    'save' => '節省',
    'delete_confirm' => '您確定要刪除該終端嗎？',
    'table' => [
      'name' => '姓名',
      'type' => '類型',
      'printer' => '印表機',
      'status' => '地位',
      'default' => '預設',
      'actions' => '行動',
    ],
    'status' => [
      'active' => '積極的',
      'inactive' => '不活躍',
    ],
    'type_options' => [
      'food' => '食物',
      'beverage' => '飲料',
      'general' => '一般的',
    ],
    'no_printer' => '無打印機',
    'default' => '預設',
  ],
  'package' => [
    'multiposLimit' => '多POS機限制',
    'multiposLimitInfo' => '這是分支限制。輸入 -1 表示每個分支機構的 POS 機數量不受限制。留空或設置正數以設置每個分支的限制。',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => '新 POS 機註冊請求',
      'push_title' => 'POS 註冊請求',
      'push_message' => ':alias 已請求 :branch 分行的 POS 訪問權限',
      'text1' => '已提交新的 POS 機註冊請求。',
      'text2' => '請審核並批准或拒絕請求：',
      'text3' => '您可以從 MultiPOS 設置頁面管理所有 POS 機請求。',
      'action' => '審核請求',
    ],
  ],
];